define(['angular', 'app', 'DirectSchedulingService', 'moment' ], function (angular, app) {
	'use strict';
	app.controller('DirectSchedulingController', function (
		$scope,
		DirectSchedulingService,
		focusService,
		connectionErrorService,
		modalService,
		formatter,
		activeInstitution,
		requestsConstants
	) {
		var anyVeteranOption = {value: "No", response: "Yes - Any Veteran"};
		var withPactOption = {value: "No", response: "Yes - With PACT Assignment"};
		var basedOnTimeFrameOption = {value: "Yes", response: "Yes - Based Upon Time Frame"};
		var allSupportedMenuOptions = [anyVeteranOption, basedOnTimeFrameOption];
		var withPactSupportedMenuOptions = [withPactOption];

		$scope.getSupportedMenuOptions = function (coreSetting) {
			if (coreSetting.id === requestsConstants.PRIMARY_CARE_CODE) {
				return withPactSupportedMenuOptions;
			}

			return allSupportedMenuOptions;
		};

		focusService.focusMain();
		$scope.formatter = formatter;
		$scope.today = new Date();
		$scope.institution = activeInstitution.divisionName;

		$scope.lastSeenMenu = [
			{value: 730, days: "24 months (730 days)"},
			{value: 365, days: "12 months (365 days)"}
		];

		$scope.directBooking = $scope.lastSavedDirectBooking = {};

		DirectSchedulingService.fetch(activeInstitution.childName).then(function(response) {
			if(response.status !== 200) {
				return connectionErrorService.showServerErrorMsg(response);
			}

			// update direct booking model
			$scope.directBooking = response.data;
			for (var i = 0; i < $scope.directBooking.coreSettings.length; i++) {
				$scope.directBooking.coreSettings[i].canCancel = true;
			}
			// update form state
			$scope.lastSavedDirectBooking = angular.copy($scope.directBooking);
		});

		var modalOptions = {
			actionButtonText: 'OK',
			headerText: 'Confirmation',
			bodyText: 'The Direct Scheduling settings have been saved.'
		};

		$scope.save = function(e){
			var fDNS   troller = this.directSchedulingForm;
			fDNS   troller.$setSubmitted();
			fDNS   troller.validationSummary.requiredValidate().then(function() {

				var httpRequestPromise = DirectSchedulingService.save($scope.directBooking,activeInstitution.childName).then(function(response){
					// update direct booking model
					$scope.directBooking = response.data;
					// update form state
					fDNS   troller.$setPristine();
					fDNS   troller.validationSummary.clear();
					$scope.lastSavedDirectBooking = angular.copy($scope.directBooking);

					// show confirmation modal
					modalService.showModal({}, modalOptions).then(function () {
						focusService.focusPrimary();
					});
				});

				fDNS   troller.validationSummary.summarizeAsync([httpRequestPromise]);
			});
		};

		$scope.reset = function(){
			var fDNS   troller = this.directSchedulingForm;
			fDNS   troller.validationSummary.clear();
			fDNS   troller.$setPristine();
			$scope.directBooking = angular.copy($scope.lastSavedDirectBooking);
		};
	});
});
